/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONATTENTEFLUX_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONATTENTEFLUX_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionAttenteFlux); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/blocmemoire.h>
#include <src/machine/flux/flux.h>
#include <src/machine/programme/donnees/typelecture.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionAttenteFlux: public Instruction
			{
				public:
					InstructionAttenteFlux(const SetLgg::Machine::Programme::ListeBlocsMemoire& flux, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _sens(SetLgg::Machine::Flux::TypeOuvertureFichier::ECRITURE), _flux(flux) {};
					InstructionAttenteFlux(const SetLgg::Machine::Programme::TypeLectureSP& mode, const SetLgg::Machine::Programme::ListeBlocsMemoire& flux, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _sens(SetLgg::Machine::Flux::TypeOuvertureFichier::LECTURE), _mode(mode), _flux(flux) {};
					virtual ~InstructionAttenteFlux() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						execution_avec_resultat(machine);
					}
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionAttenteFlux&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					SetLgg::Machine::Flux::TypeOuvertureFichier _sens;
					SetLgg::Machine::Programme::TypeLectureSP _mode;
					SetLgg::Machine::Programme::ListeBlocsMemoire _flux;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionAttenteFlux& instruction)
			{
				os << ":wait " << instruction._sens;
				if(instruction._sens==SetLgg::Machine::Flux::TypeOuvertureFichier::LECTURE)
				{
					os << " " << *(instruction._mode);
				}
				os << " " << instruction._flux;
				return os;
			};

			class AttenteFluxIncorrecte : public SetLgg::Global::Exception::Execution
			{
				public:
					AttenteFluxIncorrecte(const std::string& details = std::string())
					:Execution(SIGPIPE,std::string("Impossible to wait for a stream event")+details) {};
			};
		}
	}
}
#endif
