/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONCHERCHE_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONCHERCHE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionCherche); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/programme/donnees/nomflux.h>
#include <src/machine/flux/gestionnaireflux.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionCherche: public Instruction
			{
				public:
					InstructionCherche(const SetLgg::Machine::Programme::NomFluxSP descripteur, SetLgg::Machine::Flux::TypeCherche type, const ValeurSP& decalage, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _descripteur(descripteur), _type(type),_decalage(decalage) {};
					InstructionCherche(const SetLgg::Machine::Programme::NomFluxSP descripteur, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _descripteur(descripteur), _type(SetLgg::Machine::Flux::TypeCherche::RELATIF),_decalage(SetLgg::Machine::Programme::ValeurSP()) {};
					virtual ~InstructionCherche() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						execution_avec_resultat(machine);
					}
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionCherche&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					SetLgg::Machine::Programme::NomFluxSP _descripteur;
					SetLgg::Machine::Flux::TypeCherche _type;
					ValeurSP _decalage;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionCherche& instruction)
			{
				os << ":seek " << *(instruction._descripteur);
				if(instruction._decalage)
				{
					os << " " << instruction._type << " " << *(instruction._decalage);
				}
				return os;
			};
		}
	}
}
#endif
