/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionclone.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/booleen.h>
#include <unistd.h>
#include <sys/types.h>
using namespace SetLgg::Machine::Programme;

#define LECTURE 0
#define ECRITURE 1
namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			namespace Outil
			{
				struct TubesClone
				{
					TubesClone()
					{
						tube_lecture[LECTURE]=-1;
						tube_lecture[ECRITURE]=-1;
						tube_ecriture[LECTURE]=-1;
						tube_ecriture[ECRITURE]=-1;
					};
					~TubesClone()
					{
						if(tube_lecture[LECTURE]>=0)	{ ::close(tube_lecture[LECTURE]); }
						if(tube_lecture[ECRITURE]>=0)	{ ::close(tube_lecture[ECRITURE]); }
						if(tube_ecriture[LECTURE]>=0)	{ ::close(tube_ecriture[LECTURE]); }
						if(tube_ecriture[ECRITURE]>=0)	{ ::close(tube_ecriture[ECRITURE]); }
					}

					int tube_lecture[2];
					int tube_ecriture[2];
				};
			}
		}
	}
}

SetLgg::Machine::Memoire::ValeurSP InstructionClone::execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const
{
	if(_descripteur)
	{
		SetLgg::Machine::Memoire::NomFlux nom_flux = _descripteur->evaluation_basique(machine);
		SetLgg::Machine::Programme::Outil::TubesClone tubes;
		if(::pipe(tubes.tube_lecture)<0)
		{
			std::ostringstream details;
			details << SetLgg::Global::Exception::details << std::endl << "pipe: " << ::strerror(errno);
			throw CloneImpossible(details.str());
		}
		if(::pipe(tubes.tube_ecriture)<0)
		{
			std::ostringstream details;
			details << SetLgg::Global::Exception::details << std::endl << "pipe: " << ::strerror(errno);
			throw CloneImpossible(details.str());
		}
		
		pid_t enfant = ::fork();
		if(enfant<0)
		{
			std::ostringstream details;
			details << SetLgg::Global::Exception::details << std::endl << "fork: " << ::strerror(errno);
			throw CloneImpossible(details.str());
		}
		if(enfant==0)
		{	// fils
			SetLgg::Machine::Flux::FluxSP flux(new SetLgg::Machine::Flux::FluxPaireTubesAnonymes(tubes.tube_ecriture[LECTURE],tubes.tube_lecture[ECRITURE]));
			machine->_flux->ajoute(nom_flux,flux);
			tubes.tube_ecriture[LECTURE]=-1;
			tubes.tube_lecture[ECRITURE]=-1;
			SetLgg::Machine::Memoire::ValeurSP resultat(new SetLgg::Machine::Memoire::Booleen(true));
			return resultat;
		}
		else
		{	// pere
			SetLgg::Machine::Flux::FluxSP flux(new SetLgg::Machine::Flux::FluxPaireTubesAnonymes(tubes.tube_lecture[LECTURE],tubes.tube_ecriture[ECRITURE]));
			machine->_flux->ajoute(nom_flux,flux);
			tubes.tube_lecture[LECTURE]=-1;
			tubes.tube_ecriture[ECRITURE]=-1;
			SetLgg::Machine::Memoire::ValeurSP resultat(new SetLgg::Machine::Memoire::Booleen(false));
			return resultat;
		}
	}
	else
	{
		pid_t enfant = ::fork();
		if(enfant<0)
		{
			std::ostringstream details;
			details << SetLgg::Global::Exception::details << std::endl << "fork: " << ::strerror(errno);
			throw CloneImpossible(details.str());
		}
		SetLgg::Machine::Memoire::ValeurSP resultat(new SetLgg::Machine::Memoire::Booleen(enfant==0));
		return resultat;
	}
}
