/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <time.h>
#include <src/machine/programme/donnees/instructiondate.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/entier.h>
#include <src/machine/memoire/donnees/chaine.h>
using namespace SetLgg::Machine::Programme;

SetLgg::Machine::Memoire::ValeurSP InstructionDate::execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const
{
	time_t date;
	struct tm date_eclatee;
	SetLgg::Machine::Memoire::ValeurSP resultat;
	if(_date_unix)
	{
		SetLgg::Machine::Memoire::ValeurCSP date_unix = _date_unix->evaluation(machine);
		SetLgg::Machine::Memoire::EntierCSP entier = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Entier>(date_unix);
		if(entier)
		{
			date = *entier;
		}
		else
		{
			throw DateUnixIncorrecte();
		}
	}
	else
	{
		::time(&date);
	}
	switch(_type)
	{
		case TypeDate::TEMPS_UNIVERSEL:
			::gmtime_r(&date,&date_eclatee);
			break;
		case TypeDate::TEMPS_LOCAL:
			::localtime_r(&date,&date_eclatee);
			break;
		default:
			throw TypeDateIncorrect();
	}
	if(_format)
	{
		SetLgg::Machine::Memoire::ValeurCSP format = _format->evaluation(machine);
		SetLgg::Machine::Memoire::ChaineCSP chaine = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(format);
		if(chaine)
		{
			std::string fmt = *chaine;
			std::ostringstream res;
			res.fill('0');
			res.setf(std::ios::right);
			bool echap = false;
			for(auto it = fmt.cbegin() ; it!=fmt.cend() ; ++it)
			{
				if(echap)
				{
					switch(*it)
					{
						case 'Y':
							res.width(4);
							res << date_eclatee.tm_year+1900;
							break;
						case 'M':
							res.width(2);
							res << date_eclatee.tm_mon+1;
							break;
						case 'D':
							res.width(2);
							res << date_eclatee.tm_mday;
							break;
						case 'h':
							res.width(2);
							res << date_eclatee.tm_hour;
							break;
						case 'm':
							res.width(2);
							res << date_eclatee.tm_min;
							break;
						case 's':
							res.width(2);
							res << date_eclatee.tm_sec;
							break;
						case 'e':
							res.width(10);
							res << date;
							break;
						case 'w':
							res.width(1);
							res << date_eclatee.tm_wday;
							break;
						case 'z':
							res.width(2);
							res << date_eclatee.tm_isdst;
							break;
						case 'J':
							res.width(3);
							res << date_eclatee.tm_yday;
							break;
						default:
							res.width(1);
							res << *it;
							break;
					};
					echap = false;
				}
				else
				{
					if((*it)=='%')
					{
						echap = true;
					}
					else
					{
						res.width(1);
						res << *it;
					}
				}
			}
			resultat = SetLgg::Machine::Memoire::ValeurSP(new SetLgg::Machine::Memoire::Chaine(res.str()));
		}
		else
		{
			throw FormatDateIncorrect();
		}
	}
	else
	{
		date = ::mktime(&date_eclatee);
		resultat = SetLgg::Machine::Memoire::ValeurSP(new SetLgg::Machine::Memoire::Entier(date));
	}
	return resultat;
}
