/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONDATE_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONDATE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionDate); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			enum class TypeDate {TEMPS_UNIVERSEL, TEMPS_LOCAL};
			template<typename oStream>
			oStream& operator<<(oStream& os, const TypeDate type)
			{
				switch(type)
				{
					case TypeDate::TEMPS_UNIVERSEL:
						os << "UTC";
						break;
					case TypeDate::TEMPS_LOCAL:
						os << "LOCAL";
						break;
				}
				return os;
			}

			class InstructionDate: public Instruction
			{
				public:
					InstructionDate(const ValeurSP date_unix, SetLgg::Machine::Programme::TypeDate type, const ValeurSP& format, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _date_unix(date_unix), _type(type),_format(format) {};
					virtual ~InstructionDate() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						execution_avec_resultat(machine);
					}
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionDate&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					ValeurSP _date_unix;
					SetLgg::Machine::Programme::TypeDate _type;
					ValeurSP _format;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionDate& instruction)
			{
				os << ":date ";
				if(instruction._date_unix)
				{
					os << *(instruction._date_unix) << " ";
				}
				os << instruction._type << " ";
				if(instruction._format)
				{
					os << *(instruction._format);
				}
				return os;
			};

			class DateUnixIncorrecte : public SetLgg::Global::Exception::Execution
			{
				public:
					DateUnixIncorrecte()
					:Execution(SIGABRT,"Incorrect unix date, only INT allowed") {};
			};

			class TypeDateIncorrect : public SetLgg::Global::Exception::Execution
			{
				public:
					TypeDateIncorrect()
					:Execution(SIGABRT,"Incorrect date type, only UTC and LOCAL allowed") {};
			};

			class FormatDateIncorrect : public SetLgg::Global::Exception::Execution
			{
				public:
					FormatDateIncorrect()
					:Execution(SIGABRT,"Incorrect date format, only STR allowed") {};
			};
		}
	}
}
#endif
