/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionenfant.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/entier.h>
#include <sys/wait.h>
#include <sys/types.h>
using namespace SetLgg::Machine::Programme;

SetLgg::Machine::Memoire::ValeurSP InstructionEnfant::execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const
{
	int coderetourenfant;
	if(::wait(&coderetourenfant)<0)
	{
		std::ostringstream details;
		details << SetLgg::Global::Exception::details << std::endl << ::strerror(errno) ;
		throw AttenteEnfantImpossible(details.str());
	}
	if(WIFEXITED(coderetourenfant))
	{
		SetLgg::Machine::Memoire::ValeurSP resultat(new SetLgg::Machine::Memoire::Entier(WEXITSTATUS(coderetourenfant)));
		return resultat;
	}
	else
	{
		SetLgg::Machine::Memoire::ValeurSP resultat(new SetLgg::Machine::Memoire::EntierNul());
		return resultat;
	}
}
