/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionenvoi.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/chaine.h>
#include <src/machine/programme/donnees/instructionreception.h>
using namespace SetLgg::Machine::Programme;

void InstructionEnvoi::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::NomFlux nom_flux = _nom_flux->evaluation_basique(machine);
	SetLgg::Machine::Memoire::ValeurCSP valeur_nom_bloc = _nom_bloc->evaluation(machine);
	SetLgg::Machine::Memoire::ChaineCSP nom_bloc = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeur_nom_bloc);
	SetLgg::Machine::Memoire::Memoire::BlocMemoire bloc = _bloc_memoire(machine);
	execution_interne(machine,nom_flux,*nom_bloc,bloc);
}

void InstructionEnvoi::execution_interne(SetLgg::Machine::Machine::MachineSP& machine, const SetLgg::Machine::Memoire::NomFlux& nom_flux, const std::string nom_bloc, SetLgg::Machine::Memoire::Memoire::BlocMemoire& bloc)
{
	SetLgg::Machine::Flux::FluxSP flux=(*(machine->_flux))[nom_flux];
	if(not flux)
	{
		std::ostringstream oss;
		nom_flux.format(oss);
		throw SetLgg::Machine::Flux::FluxInexistant(oss.str());
	}
	if(not flux->inscriptible())
	{
		std::ostringstream oss;
		nom_flux.format(oss);
		throw SetLgg::Machine::Flux::FluxOperationInvalide(oss.str());
	}
	if(flux->media_actif() and not flux->lisible())
	{
		std::ostringstream oss;
		nom_flux.format(oss);
		throw SetLgg::Machine::Flux::FluxOperationInvalide(oss.str());
	}
	SetLgg::Machine::Memoire::MemoireSP memoire_bloc = machine->_memoire->exporte<false,true>(bloc);
	if(not memoire_bloc)
	{
		throw BlocMemoireInvalide(bloc);
	}
	std::ostringstream oss_bloc;
	oss_bloc << *memoire_bloc;
	SetLgg::Machine::Programme::Transfert::TransfertSP requete(new SetLgg::Machine::Programme::Transfert::RequeteBlocMemoire(nom_bloc,bloc,oss_bloc.str()));
	envoi(flux,requete);
	if(flux->media_actif())
	{
		SetLgg::Machine::Programme::Transfert::TransfertSP reponse = InstructionReception::reception(flux);
		if(not reponse or not (*reponse))
		{
			throw MessageInvalide();
		}
		SetLgg::Machine::Programme::Transfert::ReponseErreurSP erreur = std::dynamic_pointer_cast<SetLgg::Machine::Programme::Transfert::ReponseErreur>(reponse);
		if(erreur)
		{
			throw SetLgg::Global::Exception::Execution(erreur->_interruption, erreur->_message);
		}
	}
}

void InstructionEnvoi::envoi(SetLgg::Machine::Flux::FluxSP& flux, const SetLgg::Machine::Programme::Transfert::TransfertSP& requete)
{
	std::ostringstream oss_requete;
	oss_requete << (*requete);
	std::string entete = SetLgg::Machine::Programme::Transfert::Transfert::encode_entete(oss_requete.str());
	flux->ecriture(entete); // envoye a part pour l'UDP
	flux->ecriture(oss_requete.str());
}
