/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONENVOI_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONENVOI_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionEnvoi); } } }

#include <src/machine/programme/donnees/programme.h>
#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/nomflux.h>
#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/programme/donnees/blocmemoire.h>
#include <src/machine/programme/transfert/transfert.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionReception;
			class InstructionEnvoi: public Instruction
			{
				friend class InstructionReception;
				public:
					InstructionEnvoi(const NomFluxSP& nom_flux, const ValeurSP& nom_bloc, const BlocMemoire& bloc_memoire, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _nom_flux(nom_flux), _nom_bloc(nom_bloc), _bloc_memoire(bloc_memoire) {};
					virtual ~InstructionEnvoi() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionEnvoi&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					static void execution_interne(SetLgg::Machine::Machine::MachineSP& machine, const SetLgg::Machine::Memoire::NomFlux& nom_flux, const std::string nom_bloc, SetLgg::Machine::Memoire::Memoire::BlocMemoire& bloc);
				private:
					NomFluxSP _nom_flux;
					ValeurSP _nom_bloc;
					BlocMemoire _bloc_memoire;
					static void envoi(SetLgg::Machine::Flux::FluxSP& flux, const SetLgg::Machine::Programme::Transfert::TransfertSP& requete);
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionEnvoi& instruction)
			{
				os << ":send " << *(instruction._nom_flux) << " " << *(instruction._nom_bloc) << " " << instruction._bloc_memoire;
				return os;
			};

			struct BlocMemoireInvalide : public SetLgg::Global::Exception::Execution
			{
				BlocMemoireInvalide(const SetLgg::Machine::Memoire::Memoire::BlocMemoire& bloc)
				:SetLgg::Global::Exception::Execution(SIGSEGV,std::string("Invalid memory block ")+static_cast<std::string>(bloc)) {}
			};

			struct MessageInvalide : public SetLgg::Global::Exception::Execution
			{
				MessageInvalide()
				:SetLgg::Global::Exception::Execution(SIGABRT,"Invalid message") {}
			};
		}
	}
}
#endif
