/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONEXPRESSION_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONEXPRESSION_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionExpression); } } }

#include <src/machine/programme/donnees/expression.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionExpression
			{
				public:
					InstructionExpression(const ExpressionSP& expression)
					:_expression(expression) {}
					virtual ~InstructionExpression() {};
					virtual const SetLgg::Machine::Memoire::ValeurCSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						SetLgg::Machine::Memoire::ValeurCSP valeur = _expression->evaluation(machine);
						return valeur;
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os,const InstructionExpression& instruction)
					{
						return os << *(instruction._expression);
					};
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					ExpressionSP _expression;
			};
			
		}
	}
}
#endif
