/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionfermeture.h>
#include <src/machine/machine/machine.h>
using namespace SetLgg::Machine::Programme;

template<typename Sens>
void InstructionFermeture<Sens>::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::NomFlux nom_flux = _descripteur->evaluation_basique(machine);
	Sens fermeture(machine);
	fermeture(nom_flux);
}

template class InstructionFermeture<Fermeture::Complete>;
template class InstructionFermeture<Fermeture::Lecture>;
template class InstructionFermeture<Fermeture::Ecriture>;

	void Fermeture::Complete::operator() (const SetLgg::Machine::Memoire::NomFlux& nom_flux)
	{
		_machine->_flux->fermeture(nom_flux);
	}

	void Fermeture::Lecture::operator() (const SetLgg::Machine::Memoire::NomFlux& nom_flux)
	{
		_machine->_flux->fermeture_lecture(nom_flux);
	}

	void Fermeture::Ecriture::operator() (const SetLgg::Machine::Memoire::NomFlux& nom_flux)
	{
		_machine->_flux->fermeture_ecriture(nom_flux);
	}
