/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONFERMETURE_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONFERMETURE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionFermetureComplete); DECL_SHARED_PTR(InstructionFermetureLecture); DECL_SHARED_PTR(InstructionFermetureEcriture); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/nomflux.h>
#include <src/machine/flux/gestionnaireflux.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			template<typename Sens>
			class InstructionFermeture: public Instruction
			{
				public:
					virtual ~InstructionFermeture() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
						friend oStream& operator<<(oStream& os, const InstructionFermeture<Sens>& instruction)
						{
							os << ":close " << Sens::_syntaxe <<  *(instruction._descripteur);
							return os;
						};
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				protected:
					InstructionFermeture(const SetLgg::Machine::Programme::NomFluxSP& descripteur, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _descripteur(descripteur) {};
				private:
					SetLgg::Machine::Programme::NomFluxSP _descripteur;
			};

			namespace Fermeture
			{
				struct Complete
				{
					explicit Complete(const SetLgg::Machine::Machine::MachineSP& machine)
						:_machine(machine) {}
					constexpr static const char * _syntaxe = "";
					void operator() (const SetLgg::Machine::Memoire::NomFlux& nom_flux);
					private:
					SetLgg::Machine::Machine::MachineSP _machine;
				};

				struct Lecture
				{
					explicit Lecture(const SetLgg::Machine::Machine::MachineSP& machine)
						:_machine(machine) {}
					constexpr static const char *_syntaxe = "< ";
					void operator() (const SetLgg::Machine::Memoire::NomFlux& nom_flux);
					private:
					SetLgg::Machine::Machine::MachineSP _machine;
				};

				struct Ecriture
				{
					explicit Ecriture(const SetLgg::Machine::Machine::MachineSP& machine)
						:_machine(machine) {}
					constexpr static const char *_syntaxe = "> ";
					void operator() (const SetLgg::Machine::Memoire::NomFlux& nom_flux);
					private:
					SetLgg::Machine::Machine::MachineSP _machine;
				};
			}
			struct InstructionFermetureComplete : public InstructionFermeture<Fermeture::Complete>
			{
				InstructionFermetureComplete(const SetLgg::Machine::Programme::NomFluxSP& descripteur, const SetLgg::Global::Source::PositionSP& position)
				:InstructionFermeture(descripteur,position) {};
				virtual ~InstructionFermetureComplete() {};
			};

			struct InstructionFermetureLecture : public InstructionFermeture<Fermeture::Lecture>
			{
				InstructionFermetureLecture(const SetLgg::Machine::Programme::NomFluxSP& descripteur, const SetLgg::Global::Source::PositionSP& position)
				:InstructionFermeture(descripteur,position) {};
				virtual ~InstructionFermetureLecture() {};
			};

			struct InstructionFermetureEcriture : public InstructionFermeture<Fermeture::Ecriture>
			{
				InstructionFermetureEcriture(const SetLgg::Machine::Programme::NomFluxSP& descripteur, const SetLgg::Global::Source::PositionSP& position)
				:InstructionFermeture(descripteur,position) {};
				virtual ~InstructionFermetureEcriture() {};
			};
		}
	}
}
#endif
