/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONINTERRUPTION_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONINTERRUPTION_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionInterruption); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/label.h>
#include <src/machine/programme/donnees/adresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { DECL_SHARED_PTR(Machine); }
		namespace Programme
		{
			class InstructionInterruption: public Instruction
			{
				public:
					InstructionInterruption(const size_t& signal, const LabelSP& label, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _signal(signal), _label(label) { };
					virtual ~InstructionInterruption() {};
					virtual void edition_liens(ProgrammeSP programme);
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionInterruption&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					size_t _signal;
					LabelSP _label;
					AdresseSP _destination;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionInterruption& instruction)
			{
				os << ":interruption " ;
				os << SetLgg::Global::Exception::Execution::nom_interruption(instruction._signal);
				if(instruction._label)
				{
					os << " " << *(instruction._label);
				}
#ifdef SETLGG_DEBUG
				if(instruction._destination)
				{
					os << " # " << *(instruction._destination);
				}
#endif
				return os;
			};
		}
	}
}
#endif
