/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <unistd.h>
#include <src/machine/programme/donnees/instructionlecture.h>
#include <src/machine/machine/machine.h>
using namespace SetLgg::Machine::Programme;

SetLgg::Machine::Memoire::ValeurSP InstructionLecture::execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::NomFlux nom_flux = _descripteur->evaluation_basique(machine);
	::sync();
	SetLgg::Machine::Flux::TypeLecture type = (*_type)(machine);
	SetLgg::Machine::Flux::DonneesLues valeur = machine->_flux->lecture(nom_flux,type);
	if(valeur)
	{
		return _format.valeur_nulle();
	}
	SetLgg::Machine::Memoire::ValeurSP valeurconvertie = _format(valeur);
	return valeurconvertie;
}
