/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONLECTURE_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONLECTURE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionLecture); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/programme/donnees/format.h>
#include <src/machine/programme/donnees/nomflux.h>
#include <src/machine/programme/donnees/typelecture.h>
#include <src/machine/flux/gestionnaireflux.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionLecture: public Instruction
			{
				public:
					InstructionLecture(SetLgg::Machine::Programme::NomFluxSP descripteur, Format format , const SetLgg::Machine::Programme::TypeLectureSP& type, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _descripteur(descripteur), _format(format), _type(type) {};
					virtual ~InstructionLecture() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						execution_avec_resultat(machine);
					}
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionLecture&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					SetLgg::Machine::Programme::NomFluxSP _descripteur;
					Format _format;
					SetLgg::Machine::Programme::TypeLectureSP _type;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionLecture& instruction)
			{
				os << ":read " << *(instruction._descripteur) << " " << instruction._format << " " << *(instruction._type);
				return os;
			};
		}
	}
}
#endif
