/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionmarqueur.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/chaine.h>
#include <src/machine/memoire/donnees/booleen.h>
using namespace SetLgg::Machine::Programme;

void InstructionMarqueur::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::ValeurCSP valeur_marqueur = _marqueur->evaluation(machine);
	SetLgg::Machine::Memoire::ChaineCSP nom_marqueur = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeur_marqueur);
	bool action = true;
	if(_action)
	{
		SetLgg::Machine::Memoire::ValeurCSP valeur_action = _action->evaluation(machine);
		SetLgg::Machine::Memoire::BooleenCSP contenu_action = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Booleen>(valeur_action);
		action = *contenu_action;
	}
	if(action)
	{
		machine->_processeur->ajoute_marqueur(*nom_marqueur);
	}
	else
	{
		machine->_processeur->enleve_marqueur(*nom_marqueur);
	}
}
