/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONMISEAPLAT_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONMISEAPLAT_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionMiseAPlat); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/nomflux.h>
#include <src/machine/flux/gestionnaireflux.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionMiseAPlat: public Instruction
			{
				public:
					InstructionMiseAPlat(const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position) {};
					InstructionMiseAPlat(const SetLgg::Machine::Programme::NomFluxSP& descripteur, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _descripteur(descripteur) {};
					virtual ~InstructionMiseAPlat() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						execution_avec_resultat(machine);
					}
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionMiseAPlat&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					SetLgg::Machine::Programme::NomFluxSP _descripteur;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionMiseAPlat& instruction)
			{
				os << ":coredump";
				if(instruction._descripteur)
				{
					os << " " << *(instruction._descripteur);
				}
				return os;
			};
		}
	}
}
#endif
