/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONNETTOIE_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONNETTOIE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(InstructionNettoie); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/machine/machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionNettoie: public Instruction
			{
				public:
					InstructionNettoie(const AdresseMemoireSP& adresse, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _adresse(adresse) {};
					virtual ~InstructionNettoie() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						SetLgg::Machine::Memoire::AdresseSP adresse = _adresse->evaluation(machine);
						machine->_memoire->nettoie(*adresse);
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os,const InstructionNettoie& instruction)
					{
						os << ":clear " << *instruction._adresse;
						return os;
					};
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					AdresseMemoireSP _adresse;
			};
			
		}
	}
}
#endif
