/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionouverture.h>
#include <src/machine/machine/machine.h>
#include <src/machine/memoire/donnees/chaine.h>
using namespace SetLgg::Machine::Programme;
void InstructionOuverture::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::NomFlux nom_flux = _descripteur->evaluation_basique(machine);
	SetLgg::Machine::Flux::FluxSP flux = (*_flux)(machine);
	machine->_flux->ouverture(nom_flux,flux);
};

SetLgg::Machine::Flux::FluxSP InstructionOuvertureFluxFichier::operator() (SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::ValeurCSP valeurnom = _nom->evaluation(machine);
	SetLgg::Machine::Memoire::ChaineCSP nom = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeurnom);
	switch(_acces)
	{
		case Acces::LECTURE:
		{
			SetLgg::Machine::Flux::FluxSP fichier(new SetLgg::Machine::Flux::FluxFichierLectureSeule(*nom));
			return fichier;
		}
		case Acces::ECRITURE:
		{
			SetLgg::Machine::Flux::FluxSP fichier(new SetLgg::Machine::Flux::FluxFichierEcritureSeule(*nom));
			return fichier;
		}
		case Acces::LECTUREECRITURE:
		{
			SetLgg::Machine::Flux::FluxSP fichier(new SetLgg::Machine::Flux::FluxFichierLectureEcriture(*nom));
			return fichier;
		}
		case Acces::ECRITUREAJOUT:
		{
			SetLgg::Machine::Flux::FluxSP fichier(new SetLgg::Machine::Flux::FluxFichierEcritureAjout(*nom));
			return fichier;
		}
	}
	throw;
};

SetLgg::Machine::Flux::FluxSP InstructionOuvertureFluxSocket::operator() (SetLgg::Machine::Machine::MachineSP& machine) const
{
	
	switch(_protocole)
	{
		case Protocole::TCP:
			{
				switch(_acces)
				{
					case Acces::LECTURE:
						{
							SetLgg::Machine::Memoire::ValeurCSP valeuriplocale = _ip_locale->evaluation(machine);
							SetLgg::Machine::Memoire::ChaineCSP iplocale = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeuriplocale);

							SetLgg::Machine::Memoire::ValeurCSP valeurportlocal = _port_local->evaluation(machine);
							SetLgg::Machine::Memoire::ChaineCSP portlocal = valeurportlocal->en_chaine("d");

							SetLgg::Machine::Flux::FluxSP socket(new SetLgg::Machine::Flux::FluxSocketTCPServeurAttend(*iplocale,*portlocal,"",""));
							return socket;
						}
					case Acces::ECRITURE:
						{
							SetLgg::Machine::Memoire::ValeurCSP valeuripdistante = _ip_distante->evaluation(machine);
							SetLgg::Machine::Memoire::ChaineCSP ipdistante = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeuripdistante);

							SetLgg::Machine::Memoire::ValeurCSP valeurportdistant = _port_distant->evaluation(machine);
							SetLgg::Machine::Memoire::ChaineCSP portdistant = valeurportdistant->en_chaine("d");
							SetLgg::Machine::Flux::FluxSP socket(new SetLgg::Machine::Flux::FluxSocketTCPClient("","",*ipdistante,*portdistant));
							return socket;
						}
					case Acces::LECTUREECRITURE:
					case Acces::ECRITUREAJOUT:
						throw;
				}
			}
		case Protocole::UDP:
			{
				SetLgg::Machine::Memoire::ValeurCSP valeuriplocale = _ip_locale->evaluation(machine);
				SetLgg::Machine::Memoire::ChaineCSP iplocale = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeuriplocale);

				SetLgg::Machine::Memoire::ValeurCSP valeurportlocal = _port_local->evaluation(machine);
				SetLgg::Machine::Memoire::ChaineCSP portlocal = valeurportlocal->en_chaine("d");

				SetLgg::Machine::Memoire::ValeurCSP valeuripdistante = _ip_distante->evaluation(machine);
				SetLgg::Machine::Memoire::ChaineCSP ipdistante = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeuripdistante);

				SetLgg::Machine::Memoire::ValeurCSP valeurportdistant = _port_distant->evaluation(machine);
				SetLgg::Machine::Memoire::ChaineCSP portdistant = valeurportdistant->en_chaine("d");

				SetLgg::Machine::Flux::FluxSP socket(new SetLgg::Machine::Flux::FluxSocketUDP(*iplocale,*portlocal,*ipdistante,*portdistant));
				return socket;
			}
	}
	throw;
};
