/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONRECEPTION_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONRECEPTION_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionReception); } } }

#include <src/machine/programme/donnees/programme.h>
#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/nomflux.h>
#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/programme/donnees/blocmemoire.h>
#include <src/machine/programme/transfert/transfert.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionEnvoi;
			class InstructionReception: public Instruction
			{
				friend class InstructionEnvoi;
				public:
					InstructionReception(const NomFluxSP& nom_flux, const ValeurSP& nom_bloc, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _nom_flux(nom_flux), _nom_bloc(nom_bloc) {};
					InstructionReception(const NomFluxSP& nom_flux, const ValeurSP& nom_bloc, const BlocMemoireSP& bloc_memoire, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _nom_flux(nom_flux), _nom_bloc(nom_bloc), _bloc_memoire(bloc_memoire) {};
					virtual ~InstructionReception() {};
					virtual SetLgg::Machine::Memoire::ValeurSP execution_avec_resultat(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionReception&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					static SetLgg::Machine::Memoire::ValeurSP execution_interne(SetLgg::Machine::Machine::MachineSP& machine, const SetLgg::Machine::Memoire::NomFlux& nom_flux, const std::string nom_bloc, SetLgg::Machine::Memoire::Memoire::BlocMemoireSP& bloc);
				private:
					NomFluxSP _nom_flux; 
					ValeurSP _nom_bloc;
					BlocMemoireSP _bloc_memoire;
					static SetLgg::Machine::Programme::Transfert::TransfertSP reception(SetLgg::Machine::Flux::FluxSP& flux);
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionReception& instruction)
			{
				os << ":receive " << *(instruction._nom_flux) << " " << *(instruction._nom_bloc);
				if(instruction._bloc_memoire)
				{
					os << " " << *(instruction._bloc_memoire);
				}
				return os;
			};
			struct CorpsInvalide : public SetLgg::Global::Exception::Execution
			{
				CorpsInvalide()
				:SetLgg::Global::Exception::Execution(SIGABRT,"Invalid message body") {}
			};
			struct SyntaxeIncorrecte : public SetLgg::Global::Exception::Execution
			{
				SyntaxeIncorrecte()
				:SetLgg::Global::Exception::Execution(SIGABRT,"Invalid message syntax") {}
			};
			struct BlocIncorrect : public SetLgg::Global::Exception::Execution
			{
				BlocIncorrect(const std::string& nom_recu, const std::string& nom_attendu)
				:SetLgg::Global::Exception::Execution(SIGSEGV,std::string("Memory block ") + nom_recu + " received instead of " + nom_attendu) {}
			};
			struct StructureBlocIncorrecte : public SetLgg::Global::Exception::Execution
			{
				StructureBlocIncorrecte(const std::string& nom_recu, const std::string& taille_recue, const std::string& taille_attendue)
				:SetLgg::Global::Exception::Execution(SIGSEGV,std::string("Memory block ") + nom_recu + " has a size of " + taille_recue + " instead of " + taille_attendue) {}
				StructureBlocIncorrecte(const std::string& nom_recu, const std::string& taille_specifiee)
				:SetLgg::Global::Exception::Execution(SIGSEGV,std::string("Memory block ") + nom_recu + " does not have the specified size of " + taille_specifiee) {}
			};
			struct TypesIncorrects : public SetLgg::Global::Exception::Execution
			{
				TypesIncorrects()
				:SetLgg::Global::Exception::Execution(SIGSEGV,"Inconsistent type in memory block") {}
			};
		}
	}
}
#endif
