/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/instructionretour.h>
#include <src/machine/machine/machine.h>
using namespace SetLgg::Machine::Programme;

void InstructionRetour::execution(SetLgg::Machine::Machine::MachineSP& machine) const
{
	if(_nombre_retours>0)
	{
		if(_condition->evaluation_booleene(machine))
		{
			for(size_t indice=0 ; indice<_nombre_retours ; ++indice)
			{
				retour(machine,_nettoyage);
			}
		}
	}
	else
	{
		while(_condition->evaluation_booleene(machine))
		{
			retour(machine,_nettoyage);
		}
	}
}

void InstructionRetour::retour(SetLgg::Machine::Machine::MachineSP& machine, const bool nettoyage)
{
	if(nettoyage)
	{
		machine->_memoire->liberation(machine->_processeur->etat_courant()._allocation_memoire);
	}
	machine->_processeur->retour();
}
