/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONRETOUR_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONRETOUR_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionRetour); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/condition.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionRetour: public Instruction
			{
				public:
					InstructionRetour(const bool nettoyage, const ConditionSP& condition, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _nettoyage(nettoyage), _retour_defaut(true), _nombre_retours(1), _condition(condition)
					{
						_condition->est_dans_un_saut();
					};
					InstructionRetour(const bool nettoyage, const size_t nombre_retours, const ConditionSP& condition, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _nettoyage(nettoyage), _retour_defaut(false), _nombre_retours(nombre_retours), _condition(condition)
					{
						_condition->est_dans_un_saut();
					};
					virtual ~InstructionRetour() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionRetour&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					static void retour(SetLgg::Machine::Machine::MachineSP& machine, const bool nettoyage);
				private:
					bool _nettoyage;
					bool _retour_defaut;
					size_t _nombre_retours;
					ConditionSP _condition;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionRetour& instruction)
			{
				os << ":return";
				if(instruction._nettoyage)
				{
					os << " :delete";
				}
				if(not instruction._retour_defaut)
				{
					os << " " << instruction._nombre_retours;
				}
				os << " " << *(instruction._condition);
				return os;
			};
		}
	}
}
#endif
