/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONSAUT_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONSAUT_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(InstructionSaut); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/label.h>
#include <src/machine/programme/donnees/condition.h>
#include <src/machine/programme/donnees/adresse.h>
#include <src/machine/programme/donnees/dereferenceadresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionSaut: public Instruction
			{
				public:
					InstructionSaut(const Label& label_statique, const ConditionSP& condition, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _label_statique(label_statique), _condition(condition)
					{
						_condition->est_dans_un_saut();
					};
					InstructionSaut(const ValeurSP& label_dynamique, const ConditionSP& condition, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _label_dynamique(label_dynamique), _condition(condition)
					{
						_condition->est_dans_un_saut();
					};
					virtual ~InstructionSaut() {};
					virtual void edition_liens(ProgrammeSP programme);
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const;
					template<typename oStream>
					friend oStream& operator<<(oStream&,const InstructionSaut&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					Label _label_statique;
					ValeurSP _label_dynamique;
					ConditionSP _condition;
					Adresse _destination;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const InstructionSaut& instruction)
			{
				os << ":goto ";
				if(instruction._label_dynamique)
				{
					os << *(instruction._label_dynamique);
				}
				else
				{
					os << instruction._label_statique;
				}
				os << *(instruction._condition); 
#ifdef SETLGG_DEBUG
				 os << " # " << instruction._destination;
#endif
				return os;
			};
		}
	}
}
#endif
