/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONVARIATION_H_
#define _MACHINE_PROGRAMME_DONNEES_INSTRUCTIONVARIATION_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(InstructionIncremente); DECL_SHARED_PTR(InstructionDecremente); } } }

#include <src/machine/programme/donnees/instruction.h>
#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/memoire/donnees/entier.h>
#include <src/machine/machine/machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			template<int variation>
			class InstructionVariation: public Instruction
			{
				public:
					InstructionVariation(const AdresseMemoireSP& adresse, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _adresse(adresse), _entier(1) {};
					InstructionVariation(const AdresseMemoireSP& adresse, const size_t& entier, const SetLgg::Global::Source::PositionSP& position)
					:Instruction(position), _adresse(adresse), _entier(entier) {};
					virtual ~InstructionVariation() {};
					virtual void execution(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						SetLgg::Machine::Memoire::AdresseSP adresse = _adresse->evaluation(machine);
						machine->_memoire->variation(*adresse,variation*_entier);
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os,const InstructionVariation& instruction)
					{
						if(variation>0)
						{
							os << ":increase";
						}
						else
						{
							os << ":decrease";
						}
						if(instruction._entier!=1)
						{
							os << " " << instruction._entier;
						}
						os << " " << *instruction._adresse;
						return os;
					};
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
				private:
					AdresseMemoireSP _adresse;
					size_t _entier;
			};

			struct InstructionIncremente : public InstructionVariation<1>
			{
				InstructionIncremente(const AdresseMemoireSP& adresse, const SetLgg::Global::Source::PositionSP& position)
				:InstructionVariation(adresse,position) {};
				InstructionIncremente(const AdresseMemoireSP& adresse, const size_t& entier, const SetLgg::Global::Source::PositionSP& position)
				:InstructionVariation(adresse,entier,position) {};
			};
			
			struct InstructionDecremente : public InstructionVariation<-1>
			{
				InstructionDecremente(const AdresseMemoireSP& adresse, const SetLgg::Global::Source::PositionSP& position)
				:InstructionVariation(adresse,position) {};
				InstructionDecremente(const AdresseMemoireSP& adresse, const size_t& entier, const SetLgg::Global::Source::PositionSP& position)
				:InstructionVariation(adresse,entier,position) {};
			};
			
		}
	}
}
#endif
