/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_LABEL_H_
#define _MACHINE_PROGRAMME_DONNEES_LABEL_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Label); } } }

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class Label
			{
				public:
					Label() {};
					explicit Label(const std::string& label)
					:_label(label) {};
					operator std::string () const
					{
						return _label;
					};
					bool operator<(const Label& label) const
					{
						return _label<label._label;
					};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Label&);
				private:
					std::string _label;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Label& label)
			{
				return os << label._label;
			};
		}
	}
}
#endif
