/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/nomflux.h>

#include <src/machine/memoire/donnees/entier.h>
#include <src/machine/programme/donnees/format.h>
using namespace SetLgg::Machine::Programme;

const SetLgg::Machine::Memoire::ValeurCSP NomFlux::evaluation(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::ValeurCSP retour(new SetLgg::Machine::Memoire::NomFlux(evaluation_basique(machine)));
	return retour;
}

const SetLgg::Machine::Memoire::NomFlux NomFluxConstant::evaluation_basique(SetLgg::Machine::Machine::MachineSP& machine) const
{
	return _nom_flux;
}

SetLgg::Machine::Memoire::ChaineCSP NomFluxVariable::genere_nom(const SetLgg::Machine::Memoire::ValeurCSP& valeur)
{
	SetLgg::Machine::Memoire::EntierCSP entier = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Entier>(valeur);
	SetLgg::Machine::Memoire::ChaineCSP chaine;
	if(entier)
	{
		SetLgg::Machine::Programme::Format format("08d");
		chaine = SetLgg::Machine::Memoire::ChaineCSP(new const SetLgg::Machine::Memoire::Chaine(format(entier)));
	}
	else
	{
		chaine = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Chaine>(valeur);
	}
	std::string chaine_brute = *chaine;
	if(chaine_brute.empty())
	{
		throw NomFluxVideInvalide();
	}
	return chaine;
}

const SetLgg::Machine::Memoire::NomFlux NomFluxVariable::evaluation_basique(SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::ValeurCSP valeur = _nom_flux->evaluation(machine);
	SetLgg::Machine::Memoire::NomFluxCSP nom_flux = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::NomFlux>(valeur);
	if(nom_flux)
	{
		return *nom_flux;
	}
	SetLgg::Machine::Memoire::ChaineCSP chaine = NomFluxVariable::genere_nom(valeur);
	return SetLgg::Machine::Memoire::NomFlux(*chaine);
}
