/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_NOMFLUX_H_
#define _MACHINE_PROGRAMME_DONNEES_NOMFLUX_H_

#include <vector>
#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(NomFlux); typedef std::vector<NomFluxSP> VecteurNomFlux; } } }

#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/flux/flux.h>
#include <src/machine/memoire/donnees/chaine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { DECL_SHARED_PTR(Machine); }
		namespace Programme
		{
			class NomFlux : public Valeur
			{
				public:
					NomFlux() = default;
					virtual ~NomFlux() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const NomFlux&);
					virtual std::ostream& format(std::ostream& os) const =0 ;
					virtual const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const;
					virtual const SetLgg::Machine::Memoire::NomFlux evaluation_basique(SetLgg::Machine::Machine::MachineSP& machine) const =0;
					virtual operator const SetLgg::Machine::Memoire::Type&() const { return SetLgg::Machine::Memoire::Type::nom_flux(); };
					virtual operator SetLgg_Machine_Value() const { throw; };
					virtual SetLgg::Machine::Memoire::ValeurSP copie() const { throw; };
			};

			template<typename oStream>
			oStream& operator<<(oStream& os,const NomFlux& nomflux)
			{
				return nomflux.format(os);
			};
			
			class NomFluxConstant : public NomFlux
			{
				public:
					NomFluxConstant(const SetLgg::Machine::Memoire::NomFlux::Type type)
					:_nom_flux(type) {};
					NomFluxConstant(const std::string& nom)
					:_nom_flux(nom,true) {};
					virtual ~NomFluxConstant() {};
					virtual const SetLgg::Machine::Memoire::NomFlux evaluation_basique(SetLgg::Machine::Machine::MachineSP& machine) const;
					virtual std::ostream& format(std::ostream& os) const
					{
						os << _nom_flux;
						return os;
					}; 
				private:
					SetLgg::Machine::Memoire::NomFlux _nom_flux;
			};

			class NomFluxVariable : public NomFlux
			{
				public:
					NomFluxVariable(const SetLgg::Machine::Memoire::Type& type, const SetLgg::Machine::Programme::ValeurSP valeur)
					:_nom_flux(valeur), _type(type)
					{
						_nom_flux->type_voulu(type);
					};
					virtual ~NomFluxVariable() {};
					virtual const SetLgg::Machine::Memoire::NomFlux evaluation_basique(SetLgg::Machine::Machine::MachineSP& machine) const;
					virtual std::ostream& format(std::ostream& os) const
					{
						os << "$";
						if(_type==SetLgg::Machine::Memoire::Type::entier_ou_chaine())
						{
							os << "(" << (*_nom_flux) << ")";
						}
						else
						{
						os << (*_nom_flux);
						}
						return os;
					}; 
					static SetLgg::Machine::Memoire::ChaineCSP genere_nom(const SetLgg::Machine::Memoire::ValeurCSP& valeur);
				private:
					SetLgg::Machine::Programme::ValeurSP _nom_flux;
					SetLgg::Machine::Memoire::Type _type;
			};

			class NomFluxVideInvalide : public SetLgg::Global::Exception::Execution
			{
				public:
					NomFluxVideInvalide()
					:Execution(SIGABRT,"Empty stream name is invalid.") {};
			};
		}
	}
}
#endif
