/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_PLACEMEMOIRE_H_
#define _MACHINE_PROGRAMME_DONNEES_PLACEMEMOIRE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(PlaceMemoire); } } }

#include <src/machine/memoire/donnees/type.h>
#include <src/machine/memoire/donnees/alias.h>
#include <src/machine/memoire/donnees/placememoire.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class PlaceMemoire
			{
				public:
					PlaceMemoire(SetLgg::Machine::Memoire::Type type, ValeurSP repetition, SetLgg::Machine::Memoire::AliasSP alias)
					:_type(type), _repetition(repetition), _alias(alias) {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const PlaceMemoire&);
					SetLgg::Machine::Memoire::PlaceMemoire operator() (SetLgg::Machine::Machine::MachineSP& machine) const;
				private:
					SetLgg::Machine::Memoire::Type _type;
					ValeurSP _repetition;
					SetLgg::Machine::Memoire::AliasSP _alias;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const PlaceMemoire& placememoire)
			{
				os << placememoire._type;
				if(placememoire._repetition)
				{
					os << "*" << *(placememoire._repetition);
				}
				if(placememoire._alias)
				{
					os << "/" << *(placememoire._alias);
				}
				return os;
			};
		}
	}
}
#endif
