/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/donnees/typelecture.h>
#include <src/machine/memoire/donnees/entier.h>
using namespace SetLgg::Machine::Programme;


SetLgg::Machine::Flux::TypeLecture TypeLectureTaille::operator() (SetLgg::Machine::Machine::MachineSP& machine) const
{
	SetLgg::Machine::Memoire::ValeurCSP valeur = _taille->evaluation(machine);
	SetLgg::Machine::Memoire::EntierCSP entier = std::dynamic_pointer_cast<const SetLgg::Machine::Memoire::Entier>(valeur);
	long int taille = *entier;
	if(taille<0)
	{
		throw TailleLectureIncorrecte();
	}
	return SetLgg::Machine::Flux::TypeLecture(SetLgg::Machine::Flux::TypeLecture::Type::TAILLE, taille);
}
