/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_TYPE_LECTURE_H_
#define _MACHINE_PROGRAMME_DONNEES_TYPE_LECTURE_H_

#include <src/global/global.h>
#include <src/machine/flux/fluxgenerique.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(TypeLecture); } } }

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class TypeLecture
			{
				public:
					virtual ~TypeLecture() {};
					virtual void format(std::ostream& os) const =0;
					virtual SetLgg::Machine::Flux::TypeLecture operator() (SetLgg::Machine::Machine::MachineSP& machine) const = 0;
					template<typename oStream>
					friend oStream& operator<<(oStream& os,const TypeLecture& type)
					{
						type.format(os);
						return os;
					}
				protected:
					TypeLecture() {};
				private:
			};

			class TypeLectureDisponible : public TypeLecture
			{
				public:
					TypeLectureDisponible() = default;
					virtual ~TypeLectureDisponible() {};
					virtual SetLgg::Machine::Flux::TypeLecture operator() (SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return SetLgg::Machine::Flux::TypeLecture(SetLgg::Machine::Flux::TypeLecture::Type::DISPONIBLE);
					}
					virtual void format(std::ostream& os) const
					{
						os << "AVAILABLE";
					}
			};

			class TypeLectureTout : public TypeLecture
			{
				public:
					TypeLectureTout() = default;
					virtual ~TypeLectureTout() {};
					virtual SetLgg::Machine::Flux::TypeLecture operator() (SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return SetLgg::Machine::Flux::TypeLecture(SetLgg::Machine::Flux::TypeLecture::Type::TOUT);
					}
					virtual void format(std::ostream& os) const
					{
						os << "ALL";
					}
			};

			class TypeLectureLigne : public TypeLecture
			{
				public:
					TypeLectureLigne() = default;
					virtual ~TypeLectureLigne() {};
					virtual SetLgg::Machine::Flux::TypeLecture operator() (SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return SetLgg::Machine::Flux::TypeLecture(SetLgg::Machine::Flux::TypeLecture::Type::LIGNE);
					}
					virtual void format(std::ostream& os) const
					{
						os << "LINE";
					}
			};

			class TypeLectureTaille : public TypeLecture
			{
				public:
					TypeLectureTaille(const SetLgg::Machine::Programme::ValeurSP& taille)
					:_taille(taille) {}
					virtual SetLgg::Machine::Flux::TypeLecture operator() (SetLgg::Machine::Machine::MachineSP& machine) const;
					virtual ~TypeLectureTaille() {};
					virtual void format(std::ostream& os) const
					{
						os << (*_taille);
					}
				private:
					SetLgg::Machine::Programme::ValeurSP _taille;
			};

			struct TailleLectureIncorrecte : public SetLgg::Global::Exception::Execution
			{
				TailleLectureIncorrecte()
				:SetLgg::Global::Exception::Execution(SIGILL,"Invalid read size") {};
			};
		}
	}
}
#endif
