/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_PROGRAMME_DONNEES_VALEUR_H_
#define _MACHINE_PROGRAMME_DONNEES_VALEUR_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Programme { DECL_SHARED_PTR(Valeur); } } }

#include <src/machine/memoire/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Machine { DECL_SHARED_PTR(Machine); }
		namespace Programme
		{
			class Valeur : public SetLgg::Machine::Memoire::Valeur
			{
				public:
					Valeur() = default;
					virtual ~Valeur() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Valeur&);
					virtual std::ostream& format(std::ostream& os) const = 0;
					virtual const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const = 0;
					virtual void type_voulu(const SetLgg::Machine::Memoire::Type& type_voulu) { };
					virtual void explication(std::ostream& os, SetLgg::Machine::Machine::MachineSP& machine, const size_t niveau=0) const
					{
						os << SetLgg::Global::Niveau(niveau) << (*this) << " => " << (*this) << std::endl;
					};
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Valeur& valeur)
			{
				valeur.format(os);
				return os;
			};
		}
	}
}
#endif
