/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/transfert/analyseur.h>
#define YYLTYPE SetLgg::Global::Source::Position
#include <src/machine/programme/transfert/includes.h>
#include <src/machine/programme/transfert/analyseur.syn.h>

#include <sys/stat.h>
#include <unistd.h>
#define FICHIER_STDIN "-"
#include <config.h>

using namespace SetLgg::Machine::Programme::Transfert;

int transfertparse(SetLgg::Machine::Programme::Transfert::Analyseur&);
extern void* transfert_scan_string(const char *);
int transfertlex_destroy();
extern FILE* transfertin;
extern SetLgg::Global::Source::Position transfertlloc;

Analyseur::~Analyseur()
{
	::transfertlex_destroy();
}

SetLgg::Machine::Programme::Transfert::TransfertSP Analyseur::analyse_chaine(std::string source)
{
	Analyseur analyseur;
	analyseur._transfert_source=source;
	::transfert_scan_string(analyseur._transfert_source.c_str());
	if(::transfertparse(analyseur))
	{
		if(analyseur._exception)
		{
			analyseur._exception->banzai();
		}
		return SetLgg::Machine::Programme::Transfert::TransfertSP();
	}
	return analyseur._transfert;
}

