/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __ANALYSEUR_PROGRAMME_TRANSFERT_ANALYSEUR__
#define __ANALYSEUR_PROGRAMME_TRANSFERT_ANALYSEUR__
#include <cstdio>
#include <string>

#include <src/global/global.h>
namespace SetLgg { namespace Machine { namespace Programme { namespace Transfert { DECL_SHARED_PTR(Analyseur); } } } }
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>
#include <src/machine/programme/transfert/transfert.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			namespace Transfert
			{
				class Analyseur
				{
					public:
						static TransfertSP analyse_chaine(std::string source);
						~Analyseur();
					private:
						Analyseur() {};
						std::string _transfert_source;
					public:
						SetLgg::Machine::Programme::Transfert::TransfertSP _transfert;
						SetLgg::Global::Exception::GeneriqueSP _exception;
				};
			}
		}
	}
}
#endif
