/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/programme/transfert/transfert.h>
using namespace SetLgg::Machine::Programme::Transfert;

std::string Transfert::encode_entete(const std::string& requete)
{
	std::ostringstream oss;
	oss << "SETLGG ";
	char taille[1024+1];
	unsigned long int t = requete.size();
	::snprintf(taille,1024,"%09lX",t);
	oss << taille << std::endl;
	return oss.str();
}

size_t Transfert::decode_entete(const std::string& entete)
{
	if(entete.substr(0,7)!="SETLGG ")
	{
		throw EnteteInvalide();
	}
	unsigned long int taille;
	if(::sscanf(entete.substr(7).c_str(),"%09lX",&taille)!=1)
	{
		throw EnteteInvalide();
	}
	return taille;
}
