fichiers_tests()
{
	echo "PROGRAMME.setlggasm MEMOIRE_INITIALE.setlggram MEMOIRE.setlggram STDOUT STDERR CODE_RETOUR MEMOIRE.setlggram_REF STDOUT_REF STDERR_REF CODE_RETOUR_REF DIFFERENCE"
}

sauvegarde_resultat()
{
	for f in $(fichiers_tests) ;
	do
		mv $f ${NOM_TEST}_$f
	done
}

nettoyage()
{
	for f in $(fichiers_tests) ;
	do
		rm $f 2>/dev/null
		rm ${NOM_TEST}_$f 2>/dev/null
		true
	done
}

validation()
{
	FICHIER=$1
	REFERENCE=${1}_REF
	${DIFF} $REFERENCE $FICHIER > DIFFERENCE
	if  [ "x$?" != "x0" ] ; then
		echo "Test $NOM_TEST, $FICHIER non conforme :" >&2
		cat DIFFERENCE >&2
		sauvegarde_resultat
		exit 1
	fi
}

test_basique()
{
	mv PROGRAMME PROGRAMME.setlggasm
	mv MEMOIRE_INITIALE MEMOIRE_INITIALE.setlggram
	mv MEMOIRE_REF MEMOIRE.setlggram_REF
	cp MEMOIRE_INITIALE.setlggram MEMOIRE.setlggram
	LD_LIBRARY_PATH=$builddir/src/machine/plugin/interface/.libs $builddir/setlgg_machine PROGRAMME.setlggasm MEMOIRE.setlggram $@ > STDOUT 2> STDERR
	echo $? > CODE_RETOUR

	validation MEMOIRE.setlggram
	validation STDOUT
	validation STDERR
	validation CODE_RETOUR
	nettoyage
}

test_basique_bg_debut()
{
	mv PROGRAMME PROGRAMME.setlggasm
	mv MEMOIRE_INITIALE MEMOIRE_INITIALE.setlggram
	mv MEMOIRE_REF MEMOIRE.setlggram_REF
	cp MEMOIRE_INITIALE.setlggram MEMOIRE.setlggram
	LD_LIBRARY_PATH=$builddir/src/machine/plugin/interface/.libs $builddir/setlgg_machine PROGRAMME.setlggasm MEMOIRE.setlggram $@ > STDOUT 2> STDERR &
	PID_MACHINE=$!
}

test_basique_bg_fin()
{
	while [[ $(jobs |wc -l) -gt 0 ]] ;
	do
		jobs > /dev/null
	done
	validation MEMOIRE.setlggram
	validation STDOUT
	validation STDERR
	nettoyage
}

chrono_debut()
{
	CHRONO_START=$(date '+%s%N' | sed 's/[0-9]\{6\}$//')
}

chrono_fin_test()
{
	CHRONO_STOP=$(date '+%s%N' | sed 's/[0-9]\{6\}$//')
	REAL_TIME=$(( $CHRONO_STOP - $CHRONO_START ))
	DIFF_TIME=$(( $REAL_TIME - $1))
	if [[ $DIFF_TIME -lt 0 ]] ; then
		DIFF_TIME=$(( - $DIFF_TIME ))
	fi
	if [[ $DIFF_TIME -gt $2 ]] ; then
		echo "Time $REAL_TIME mismatches $1 +/- $2 ms" >&2
		exit 1
	fi
}

attend_port_libre()
{
	echo -n "Port $1: "
	while [[ $(netstat -laute | grep ":$1[^0-9]" | wc -l) -ne 0 ]] ;
	do
		echo -n "."
		sleep 1
	done
	echo
}

NOM_TEST=$(basename $0)
