/*
 * Simple Virtual Machine - A versatile and robust architecture to
 * easily write applications.
 * Copyright (C) 2021  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/machine/elements/valeur/point_entree_extension.h>

#include <src/machine/elements/valeur/exception.h>

using namespace SVM::Machine::Element::Valeur;

struct PointEntreeExtensionInvalide : public SVM_Valeur::ExceptionExecution
{
	explicit PointEntreeExtensionInvalide(const std::string& champ)
		:ExceptionExecution(SVM_Valeur::Interruption::InterruptionInterne::ECHEC)
	{
		DETAILS_EXCEPTION("Plugin entry point " << champ << " field is empty.");
	}
};

PointEntreeExtension::PointEntreeExtension(const std::string& nom_extension, const std::string& nom_entree)
:_nom_extension(nom_extension), _nom_entree(nom_entree)
{
	if(nom_extension.empty())
	{
		throw PointEntreeExtensionInvalide("plugin");
	}
	if(nom_entree.empty())
	{
		throw PointEntreeExtensionInvalide("entry");
	}
}
